from pydantic import BaseSettings, Field

PROJECT_NAME = "IotManager"


class _Services(BaseSettings):
    HOST: str = Field(default="127.0.0.1", env="service_host")
    PORT: int = Field(default=8000, env="service_port")


class _Databases(BaseSettings):
    MONGO_URI: str


Services = _Services()
Databases = _Databases()

__all__ = [
    "PROJECT_NAME",
    "Services",
    "Databases",
]
