"""

Author: Arun Uday
Email: arun.uday@knowledgelens.com

Asset Manager Login For Normal User
---------------------------------------------------------
For instructions on how to run, check README.md


"""
if __name__ == "__main__":
    from dotenv import load_dotenv

    load_dotenv()

import uvicorn
from scripts.services import router
from scripts.config import PROJECT_NAME, Services as ServiceConf
from fastapi.middleware.cors import CORSMiddleware
from scripts.logging.logger import logger

# starting the application
if __name__ == "__main__":
    try:
        print("Api for " + PROJECT_NAME)
        if ServiceConf.ENABLE_CORS:
            router.add_middleware(
                CORSMiddleware,
                allow_origins=ServiceConf.CORS_URLS,
                allow_credentials=ServiceConf.CORS_ALLOW_CREDENTIALS,
                allow_methods=ServiceConf.CORS_ALLOW_METHODS,
                allow_headers=ServiceConf.CORS_ALLOW_HEADERS,
            )
        uvicorn.run(router, port=int(ServiceConf.PORT))
    except Exception as e:
        logger.error(e)


