from fastapi import APIRouter

from scripts.constants.api import ApiEndPoints
from scripts.core.handlers.loginmanager import LoginManager
from scripts.schemas.login_schema import NormalLogin

router = APIRouter(prefix=ApiEndPoints.version)


@router.post(ApiEndPoints.asset_manager_login)
def login_default(login_data: NormalLogin):
    obj_login_manager = LoginManager()
    password_hashed = obj_login_manager.hashed_password(login_data.password)
    return password_hashed


@router.post(ApiEndPoints.asset_manager_submit)
def submit_login_details():
    return {"message": "its working"}
