from fastapi import APIRouter, status
from fastapi.responses import JSONResponse

from scripts.constants.api import ApiEndPoints
from scripts.core.handlers.login_handler import LoginHandlers
from scripts.logging.logger import logger
from scripts.schemas.default_responses import DefaultResponse, DefaultFailureResponse
from scripts.schemas.login_schema import NormalLogin

# creating the login api
router = APIRouter(prefix=ApiEndPoints.version)
# initializing the handler
obj_login_handler = LoginHandlers()


@router.post(ApiEndPoints.asset_manager_submit)
def login_default(login_data: NormalLogin):
    try:
        # decrypting the password from the UI
        decrypted_password = obj_login_handler.password_decrypt(login_data.password)

        # validating the received inputs empty or not
        response = obj_login_handler.user_data_validation(login_data.username, decrypted_password)
        if response is not None:
            return JSONResponse(content=DefaultFailureResponse(error=response["message"]).dict(),
                                status_code=status.HTTP_400_BAD_REQUEST)

        # checking for the account and password matching
        response, data = obj_login_handler.db_password_matching(login_data.username, decrypted_password)
        if response is not None:
            return JSONResponse(content=DefaultFailureResponse(error=data).dict(),
                                status_code=status.HTTP_401_UNAUTHORIZED)

        # sending successful response to UI
        return JSONResponse(
            content=DefaultResponse(message="Login Successful", payload=data).dict(),
            status_code=status.HTTP_200_OK)
    except Exception as e:
        logger.exception(e)
