"""

Author: Arun Uday
Email: arun.uday@knowledgelens.com

Asset Manager Login For Normal User
---------------------------------------------------------


"""
if __name__ == "__main__":
    from dotenv import load_dotenv

    load_dotenv()

from fastapi import FastAPI
from scripts.services import router
from scripts.config import PROJECT_NAME, Services as ServiceConf
from fastapi.middleware.cors import CORSMiddleware
from scripts.logging.logger import logger

app = FastAPI()
app.include_router(router)

# starting the application
if __name__ == "__main__":
    try:
        print("Api for " + PROJECT_NAME)
        # enabling cors for getting UI data
        if ServiceConf.ENABLE_CORS:
            app.add_middleware(
                CORSMiddleware,
                allow_origins=ServiceConf.CORS_URLS,
                allow_credentials=ServiceConf.CORS_ALLOW_CREDENTIALS,
                allow_methods=ServiceConf.CORS_ALLOW_METHODS,
                allow_headers=ServiceConf.CORS_ALLOW_HEADERS,
            )
    except Exception as e:
        logger.error(e)
