import re

from scripts.logging.logger import logger


class RegexValidation:
    @staticmethod
    def first_name_validation(first_name):
        try:
            regex = re.fullmatch('([A-Za-z ]{1,100})', str(first_name))
            return regex
        except Exception as e:
            logger.error(f'An Error While listing the home plans {str(e)}')

    @staticmethod
    def name_validation(name):
        try:
            regex = re.fullmatch(r'^([A-Za-z]+)*$', str(name))
            return regex
        except Exception as e:
            logger.error(f'An Error While listing the home plans {str(e)}')

    @staticmethod
    def phone_number_validation(phone_number):
        try:
            regex = re.fullmatch('([0-9]{1,20})', str(phone_number))
            return regex
        except Exception as e:
            logger.error(f'An Error While listing the home plans {str(e)}')

    @staticmethod
    def email_validation(email):
        try:
            regex = r'\b[A-Za-z0-9._%+-]+@([A-Za-z0-9.-]{5,20})+\.[A-Z|a-z]{3}\b'
            if re.fullmatch(regex, email):
                return regex
        except Exception as e:
            logger.error(f'An Error While listing the home plans {str(e)}')

    @staticmethod
    def password_validation(password):
        try:
            password_regex = r'^(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%^&*()_+={}[\]:;\"\'|,.<>\/?]).{8,15}$'
            if re.search(password_regex, password):
                return False

        except Exception as e:
            logger.error(f'An Error While listing the home plans {str(e)}')
