from fastapi.responses import JSONResponse
from fastapi import status
from scripts.schemas.default_responses import DefaultResponse


class DashboardManagement:
    def __init__(self):
        self.download_files = {
            "SCN101-Manual (Local Config with IoTSetupUI)":
                "https://ilens.io/DownloadFiles/SCN_Device_Configuration_Page_Updates_4_7.pdf",
            "SCN101 Firmware 4.7 Updates":
                "https://ilens.io/DownloadFiles/SCN101Manual.pdf",
            "IoTSetupUI":
                "https://ilens.io/DownloadFiles/IoTsetupUI-V1.6.zip",
            "CP2102 SCN Windows USB Driver":
                "https://ilens.io/DownloadFiles/CP2102_Windows.zip",
            "SCNFirmwareBurner":
                "https://ilens.io/DownloadFiles/flash_download_tool_v3.8.5.zip",
            "SCN101A Firmware - V2.7 (Board: 1.4, 1.6 and 4MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_Firmware_V2_7_B1_6.bin",
            "SCN101A Firmware - V2.8 (Board: 1.4, 1.6 and 4MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_Firmware_V2_8_B1_6.bin",
            "SCN101A4G (SCN Relay, 4G, SCN201 and SCN101L) Firmware - V4.5 (16MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_R_A4G_SCN201_Firmware_V4_5.bin",
            "SCN101A4G (SCN Relay, 4G, SCN201 and SCN101L) Firmware - V4.6 (16MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_R_A4G_SCN201_Firmware_V4_6.bin",
            "SCN101A4G (SCN Relay, 4G, SCN201 and SCN101L) Firmware - V4.7 (16MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_R_A4G_SCN201_Firmware_V4_7.bin",
            "P10_LED_Driver_V2.1 (Board 1.1)":
                "https://ilens.io/DownloadFiles/P10_LED_Driver_V2.1.bin",
            "SCN-LED Reset Firmware (Board 1.1)":
                "https://ilens.io/DownloadFiles/SCN-LED_Reset.bin",
            "SCN Reset Firmware (Partition: 4MB)":
                "https://ilens.io/DownloadFiles/SCN_Reset_4MB_Part.bin",
            "SCN Reset Firmware (Partition: 16MB)":
                "https://ilens.io/DownloadFiles/SCN_Reset_16MB_Part.bin"
        }

    def download_header(self):
        data = {
            "actions": [
                {
                    "class": "fa-download",
                    "action": "download",
                    "tooltip": "Download"
                }
            ],
            "column_defs": []
        }
        print(data["column_defs"])
        column_values = {{"header_name": key, "field": key, "key": "file_name"} for key in self.download_files}
        print(column_values)
        data["column_defs"].append(column_values)
        print(data)
        return JSONResponse(
            content=DefaultResponse(status="success", message="Fetched Successfully",
                                    data=data).dict(),
            status_code=status.HTTP_200_OK)

    @staticmethod
    def download_details():
        return JSONResponse(
            content=DefaultResponse(status="success", message="Fetched Successfully",
                                    data=download_files).dict(),
            status_code=status.HTTP_200_OK)
