from fastapi import APIRouter

from scripts.constants.api import ApiEndPoints
from scripts.core.handlers.loginmanager import LoginManager
from scripts.logging.logger import logger
from scripts.schemas.login_schema import NormalLogin

router = APIRouter(prefix=ApiEndPoints.version)


@router.post(ApiEndPoints.asset_manager_submit)
def login_default(login_data: NormalLogin):
    try:
        obj_login_manager = LoginManager()
        password_hashed = obj_login_manager.hashed_password(login_data.password)
        cursor_user_data = obj_login_manager.get_data(login_data.username)
        user_exists = obj_login_manager.verify_password(password_hashed, cursor_user_data["password"])
        return user_exists
    except Exception as e:
        logger.exception(e)
