class ResponseData:
    @staticmethod
    def user_view():
        header = {
            "actions": [
                {
                    "class": "fa-pencil",
                    "action": "edit",
                    "tooltip": "Edit"
                },
                {
                    "class": "fa-trash",
                    "action": "delete",
                    "tooltip": "Delete"
                }
            ], "externalActions": [
                {
                    "type": "button",
                    "action": "addnew",
                    "label": "Create User"
                }
            ], "columnDefs": [
                {
                    "headerName": "User Name",
                    "field": "userName",
                    "key": "userName"
                },
                {
                    "headerName": "Name",
                    "field": "name",
                    "key": "name"
                },
                {
                    "headerName": "Role",
                    "field": "role",
                    "key": "role"
                }
            ],

        }
        return header

    @staticmethod
    def download_file_data():
        data = {
            "SCN101-Manual (Local Config with IoTSetupUI)":
                "https://ilens.io/DownloadFiles/SCN_Device_Configuration_Page_Updates_4_7.pdf",
            "SCN101 Firmware 4.7 Updates":
                "https://ilens.io/DownloadFiles/SCN101Manual.pdf",
            "IoTSetupUI":
                "https://ilens.io/DownloadFiles/IoTsetupUI-V1.6.zip",
            "CP2102 SCN Windows USB Driver":
                "https://ilens.io/DownloadFiles/CP2102_Windows.zip",
            "SCNFirmwareBurner":
                "https://ilens.io/DownloadFiles/flash_download_tool_v3.8.5.zip",
            "SCN101A Firmware - V2.7 (Board: 1.4, 1.6 and 4MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_Firmware_V2_7_B1_6.bin",
            "SCN101A Firmware - V2.8 (Board: 1.4, 1.6 and 4MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_Firmware_V2_8_B1_6.bin",
            "SCN101A4G (SCN Relay, 4G, SCN201 and SCN101L) Firmware - V4.5 (16MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_R_A4G_SCN201_Firmware_V4_5.bin",
            "SCN101A4G (SCN Relay, 4G, SCN201 and SCN101L) Firmware - V4.6 (16MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_R_A4G_SCN201_Firmware_V4_6.bin",
            "SCN101A4G (SCN Relay, 4G, SCN201 and SCN101L) Firmware - V4.7 (16MB Part.) ":
                "https://ilens.io/DownloadFiles/SCN101_R_A4G_SCN201_Firmware_V4_7.bin",
            "P10_LED_Driver_V2.1 (Board 1.1)":
                "https://ilens.io/DownloadFiles/P10_LED_Driver_V2.1.bin",
            "SCN-LED Reset Firmware (Board 1.1)":
                "https://ilens.io/DownloadFiles/SCN-LED_Reset.bin",
            "SCN Reset Firmware (Partition: 4MB)":
                "https://ilens.io/DownloadFiles/SCN_Reset_4MB_Part.bin",
            "SCN Reset Firmware (Partition: 16MB)":
                "https://ilens.io/DownloadFiles/SCN_Reset_16MB_Part.bin"
        }
        return data
