from typing import Optional

from pydantic import BaseModel


# model for login request
class LoginRequest(BaseModel):
    email: str
    password: str


class RegistrationData(BaseModel):
    name: str
    email: str
    password: Optional[str]
    phone_number: Optional[str]
    login_type: str
    user_role: str


class UserUpdate(BaseModel):
    name: Optional[str] = None
    email: Optional[str] = None
    phone_number: Optional[str] = None
    user_role: Optional[str] = None


class EmailValidation(BaseModel):
    email: str
