from __future__ import annotations

from validate_email import validate_email

from scripts.errors import ErrorMessages
from scripts.logging.logger import logger


# user data validations
class UserDataValidations:
    @staticmethod
    def register_data_validation(user_data, method, feature):
        try:
            if user_data.name == "":
                return False, {"message": ErrorMessages.ERROR_INVALID_NAME,
                               "data": user_data.phone_number}
            # checking for valid username
            if user_data.email == "" or validate_email(
                    user_data.email) is not True:
                return False, {"message": ErrorMessages.ERROR_INVALID_EMAIL, "data": user_data.email}
            # checking for valid password
            if method == 'general':
                if user_data.password == "" or user_data.password == "string":
                    return False, {"message": ErrorMessages.ERROR_INVALID_PASSWORD, "data": user_data.password}
                # Validate phone number
                if user_data.phone_number == "":
                    return False, {"message": ErrorMessages.ERROR_INVALID_PHONE_NUMBER,
                                   "data": user_data.phone_number}
            if user_data.user_role == "" and method == 'general' and feature == 'register':
                return False, {"message": ErrorMessages.ERROR_INVALID_USER_ROLE,
                               "data": user_data.phone_number}
            return True, None
        except Exception as e:
            logger.exception(e)

    @staticmethod
    def update_data_validation(user_data):
        try:
            if user_data.name == "":
                return False, {"message": ErrorMessages.ERROR_INVALID_NAME,
                               "data": user_data.phone_number}
            if user_data.user_role == "":
                return False, {"message": ErrorMessages.ERROR_INVALID_USER_ROLE,
                               "data": user_data.phone_number}
            return True, None
        except Exception as e:
            logger.exception(e)
