from scripts.config import Databases
from scripts.constants.db_constants import DatabaseConstants
from scripts.database.mongo import CollectionBaseClass, mongo_client

collection_name = DatabaseConstants.collection_user_details


class UserDetailsKeys:
    KEY_NAME = "name"
    KEY_EMAIL = "email"
    KEY_PASSWORD = "password"
    KEY_USER_ROLE = "user_role"
    KEY_IS_ALIVE = "is_alive"
    KEY_CREATED_AT = "created_at"
    KEY_UPDATED_AT = "updated_at"


class MongoUser(CollectionBaseClass):
    key_name = UserDetailsKeys.KEY_NAME
    key_email = UserDetailsKeys.KEY_EMAIL
    key_password = UserDetailsKeys.KEY_PASSWORD
    key_user_role = UserDetailsKeys.KEY_USER_ROLE
    key_is_alive = UserDetailsKeys.KEY_IS_ALIVE
    key_created_at = UserDetailsKeys.KEY_CREATED_AT
    key_updated_at = UserDetailsKeys.KEY_UPDATED_AT

    def __init__(self):
        super().__init__(mongo_client, Databases.DB_NAME, collection_name)

    # fetching the user details based on the email id
    def fetch_one_user_details(self, email):
        if user := self.find_one(query={self.key_email: email}):
            return user
        return None

    def fetch_all_user_details(self, query, filter_data):
        if user := self.find(query=query, filter_dict=filter_data):
            return user
        return None

    def insert_new_user(self, data):
        if user := self.insert_one(data=data):
            return user
        return None

    # updating the login time
    def update_user(self, query, update):
        if user := self.update_one(query=query, data=update):
            return user
        return None

    # deleting users
    def delete_user(self, query):
        if user := self.delete_one(query=query):
            return user
        return None
