from fastapi import APIRouter
from scripts.config.redis_connection import conn
from scripts.constants.end_points import EndPoints
from scripts.core.handlers.book_ticket import BookingDetails, BookTicket
from scripts.core.handlers.create_redis_db import redis_db_create
from scripts.core.handlers.get_all_the_data import seat_availability
from scripts.database.schema import FilmTicket
from scripts.logging.logging import logger

router = APIRouter()


@router.get(EndPoints.root, tags=["root"])
def root():
    return {"data": "ticket booking task"}


@router.get(EndPoints.show_begin, tags=["Show begin"])
def generate_seats():
    try:
        redis_db_create(conn, "gold", 30, 300)
        redis_db_create(conn, "silver", 25, 125)
        return "booking started"
    except Exception as e:
        logger.error(e)
        print(e)


@router.get(EndPoints.seat_availability,tags=["check seat availability"])
def check_seats(ticket_class: str):
    message = seat_availability(conn, ticket_class)
    return message


@router.post(EndPoints.book_ticket, tags=["book tickets"])
def book_ticket(ticket: FilmTicket):
    try:
        return BookTicket.book_ticket(ticket)
    except Exception as e:
        print(e)
        logger.error(e)


@router.get(EndPoints.get_booking_details, tags=["get booking details"])
def get_booking_details():
    try:
        BookingDetails.get_details()
        return {"data": "list all the data"}
    except Exception as e:
        logger.error(e)
        print(e)
