from fastapi import APIRouter
from scripts.constants.end_points import EndPoints
from scripts.core.handlers.delete_ticket import db_handler

delete_ticket = APIRouter()


@delete_ticket.post(EndPoints.delete_a_ticket, tags=["delete a ticket"])
def delete_tickets(tid: int):
    res = db_handler.delete_row(tid)
    return {f'tickets {res} deleted'}


@delete_ticket.get(EndPoints.cancel_all_tickets, tags=["cancel show"])
async def cancel_all_tickets():
    db_handler.cancel_tickets()
    return {"Message": "Cancelled all Tickets"}
