import uvicorn
from fastapi import FastAPI
from scripts.logging.logging import logger
from scripts.services.delete_ticket import delete_ticket
from scripts.services.publish import router

app = FastAPI()
app.include_router(router)
app.include_router(delete_ticket)
if __name__ == "__main__":
    try:
        uvicorn.run(app, port=8765)
    except Exception as e:
        logger.error(e)
        print(e)
