from datetime import datetime
from sqlalchemy import Column, String, Integer, Boolean, DateTime
from sqlalchemy.orm import declarative_base

Base = declarative_base()


class Ticket(Base):
    __tablename__ = "ticket_details"
    booking_id = Column(Integer, primary_key=True)
    mobile_no = Column(String, unique=True)
    preferred_class = Column(String)
    no_of_tickets = Column(Integer)
    seat_no = Column(String)
    date_of_purchase = Column(DateTime, default=datetime.now())
    age = Column(Integer)
    deleted = Column(Boolean, default=False)
