import json
import paho.mqtt.client as mqtt
from scripts.config.application_config import host, can_topic, del_topic
from scripts.config.db_connect import db_connect
from scripts.database.model import Ticket
from scripts.logging.logging import logger


class db_handler:

    @staticmethod
    def delete_row(booking_id):
        try:
            client = mqtt.Client()
            client.connect(host, 1883, 60)
            # Soft delete a row in the ticket_details table
            session = db_connect()
            ticket = session.query(Ticket).filter(Ticket.booking_id == booking_id).first()
            if ticket is not None:
                ticket.deleted = True
                session.commit()
                no_seats = ticket.seat_no
                data_of_list = no_seats.split(",")
                integer_list = [int(item) for item in data_of_list]
                data = {ticket.preferred_class: integer_list}
                client.publish(del_topic, json.dumps(data))
                return data
            else:
                print(f"Ticket with id {booking_id} is not exist")
                logger.error(f"Ticket with id {booking_id} is not exist")
                return {"message": f"ticket with id {booking_id} not exist",
                        "status": "Ticket not exist",
                        "data": booking_id}

        except Exception as e:
            logger.error(e)

    @staticmethod
    def cancel_tickets():
        try:
            client = mqtt.Client()
            client.connect(host, 1883, 60)
            session = db_connect()
            query = session.query(Ticket).update({Ticket.deleted: True})
            # Commit the changes to the database
            session.commit()
            if query is not None:
                # Publish the Message
                message = "Show Cancelled"
                client.publish(can_topic, message)
        except Exception as e:
            logger.error(e)
