import json
import pandas as pd
from fastapi import HTTPException
import paho.mqtt.client as mqtt
from scripts.config.application_config import token, host, file_path
from scripts.config.db_connect import db_connect
from scripts.config.redis_connection import conn
from scripts.core.handlers.avail_seat_redis import check_seat_avail
from scripts.core.handlers.format_data_from_db import clean_record
from scripts.database.model import Ticket
from scripts.logging.logging import logger


class BookTicket:
    @staticmethod
    def book_ticket(ticket):
        try:
            client = mqtt.Client()
            client.connect(host, 1883, 60)
            booked_list = []

            # Check if the data entered
            if ticket.no_of_tickets > 5:
                return HTTPException(status_code=400, detail="Can book only 5 tickets at a time.")
            if ticket.preferred_class not in ["gold", "silver"]:
                return HTTPException(status_code=400, detail="Invalid class type")
            seats = ticket.seat_no.split(",")
            integer_list = [int(item) for item in seats]
            if len(integer_list) != ticket.no_of_tickets:
                return HTTPException(status_code=400,
                                     detail="Number of seat numbers must match the number of tickets")

            for seat_ in integer_list:
                if seat_ not in booked_list:
                    if not check_seat_avail(conn, ticket.preferred_class, int(seat_)):
                        booked_list.append(seat_)
            if booked_list:
                return HTTPException(status_code=400,
                                     detail=f"Seat number that are already booked are : {booked_list} \n"
                                            f"seat number you are going to book  are {integer_list}")

            payload = {ticket.preferred_class: integer_list}
            client.publish(token + ticket.preferred_class, json.dumps(payload))
            # save ticket details to database
            save_ticket = Ticket(
                mobile_no=ticket.mobile_no,
                preferred_class=ticket.preferred_class,
                no_of_tickets=ticket.no_of_tickets,
                seat_no=ticket.seat_no,
                age=ticket.age
            )

            session = db_connect()
            session.add(save_ticket)
            session.commit()
            return "ticket booked successfully"
        except Exception as e:
            print(e)
            logger.error(e)


class BookingDetails:
    @staticmethod
    def get_details():
        try:
            session = db_connect()
            records = session.query(Ticket).all()
            dict_records_clean = clean_record(records)
            # Use pandas to convert the list of dictionaries to a DataFrame
            df = pd.DataFrame(dict_records_clean)
            # Use pandas to save the DataFrame to an Excel file
            df.to_excel(file_path, index=False)
        except Exception as e:
            logger.error(e)
