from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker
from scripts.database.model import Base
from scripts.logging.logging import logger


def db_connect():
    try:
        engine = create_engine("postgresql://postgres:123@localhost/ticket")
        sessions = sessionmaker(autocommit=False, autoflush=False, bind=engine)
        Base.metadata.create_all(engine)
        session = sessions()
        return session
    except Exception as e:
        logger.error(e)
        print(e)
