import configparser
import os
from dotenv import load_dotenv

try:
    config = configparser.ConfigParser()
    config.read(r"conf\app.conf")
    # logging file path
    file_name = config.get("log_file_path1", "file_name")
    # Excel file path
    file_path = config.get("excel_path", "file_path")
except configparser.NoOptionError as e:
    print(f"could not find conf file {e}")

try:
    load_dotenv()
    token = os.getenv("TOKEN")
    del_topic = os.getenv("DELETE_TOPIC")
    can_topic = os.getenv("CANCEL_TOPIC")
    postgres_uri = os.getenv("POSTGRES_URI")
    host = os.getenv("MQTT_HOST")
    port_no = os.getenv("PORT")
    table_name = os.getenv("TABLE_NAME")
except Exception as e:
    print(e)
