import redis
from paho.mqtt import client as mqtt_client
from script.config.appconfig import redis_host, redis_port, redis_db
from script.core.handlers.mqttconnection import mqtt_connection
from script.core.handlers.operations import redis_operation

# creating redis db
r1 = redis.Redis(host=redis_host, port=redis_port, db=redis_db)


def connect_mqtt():
    # creating mqtt connection
    return mqtt_connection()


def subscribe(client: mqtt_client):
    def on_message(client, userdata, msg):
        # performing update on redis
        redis_operation(r1, msg)
    client.subscribe("ticket2/#")
    client.on_message = on_message


def run():
    try:
        client = connect_mqtt()
        subscribe(client)
        client.loop_forever()
    except KeyboardInterrupt:
        client.loop_stop()
