import json
from script.core.handlers.updatingSeats import cancelled_ticket, golden_update


def redis_operation(r1, msg):
    # accepting payload
    topic_map = {
        "ticket2/cancel_all": ("gold_available_seats", "silver_available_seats", "show_cancelled"),
        "ticket2/delete": {
            "gold": ("gold_available_seats", "gold", "seats_golden"),
            "silver": ("silver_available_seats", "silver", "seats_silver"),
        },
        "ticket2/gold": {
            "gold": ("gold_available_seats", "gold", "seats_golden"),
            "silver": ("silver_available_seats", "silver", "seats_silver"),
        },
        "ticket2/silver": {
            "gold": ("gold_available_seats", "gold", "seats_golden"),
            "silver": ("silver_available_seats", "silver", "seats_silver"),
        }
    }

    topic = msg.topic
    payload = json.loads(msg.payload.decode())
    class_type, seats_booked = next(iter(payload.items()))

    try:
        print(f"{msg.payload.decode()}` topic `{msg.topic}` ")
        seat_available, redis_key, action = topic_map[topic][class_type]
    except KeyError:
        print("Invalid topic or class type")
        return

    if topic == "ticket2/cancel_all":
        r1.mset({seat_available: action, redis_key: action})
    elif topic == "ticket2/delete":
        cancelled_ticket(r1, seats_booked, redis_key, seat_available)
    else:
        golden_update(r1, seats_booked, redis_key, seat_available)
