from fastapi import FastAPI
from scripts.core.handlers.publisher_handler import PublishHandler
from scripts.logging.logging import logger
from scripts.model.patients import patients
from scripts.constants.end_points import EndPoints
app = FastAPI()


@app.get(EndPoints.root, tags=["root"])
def root():
    return {"data": "mqtt-redis publish"}


@app.post(EndPoints.publish, tags=["assign doctor and publish"])
def publish_data(details: patients):
    try:
        PublishHandler.main_handler(details)
    except Exception as e:
        logger.error(f'assign a doctor and publishing the details  failed: {e}')
    return {"data": "data published"}
