import json
from paho.mqtt import client as mqtt_client
from scripts.config.application_config import hostname, port_num
from scripts.config.redis_connection import r
from scripts.core.handlers.get_next_doctor import get_next_doctor
from scripts.logging.logging import logger

broker = hostname
port = int(port_num)
client = mqtt_client.Client()
client.connect(broker, port, 60)


def assign_patient(patient, doctors):
    try:
        # Get the next doctor for the patient
        next_doctor = get_next_doctor(doctors)

        # Check if the patient has an assigned doctor
        if r.hexists(patient['patient_id'], 'doctor'):
            # Get the assigned doctor for the patient
            assigned_doctor = r.hget(patient['patient_id'], 'doctor').decode('utf-8')

            # Check if the assigned doctor is still on duty
            if assigned_doctor in doctors:
                # Assign the patient to the same doctor
                next_doctor = assigned_doctor

        # Assign the patient to the next doctor
        patient.update({"doctor": next_doctor})
        r.hset(patient['patient_id'], 'doctor', next_doctor)
        topic = f"hospital/{next_doctor}"
        client.publish(topic, json.dumps(patient))
    except Exception as e:
        logger.error(f"could not assign patient: {e}")
