from scripts.config.redis_connection import r
from scripts.logging.logging import logger


def get_next_doctor(doctors):
    try:
        # Get the current doctor index from Redis
        current_doctor = int(r.get('current_doctor') or 0)

        # Update the current doctor index in Redis
        r.set('current_doctor', (current_doctor + 1) % len(doctors))

        # Return the next doctor
        return doctors[current_doctor]
    except Exception as e:
        logger.error(f'cant find next doctor:{e}')
