from scripts.logging.logging import logger


def insert(student):
    try:
        rn = int(input("enter the roll number"))
        f_name = input("enter first name")
        l_name = input("enter last name")
        age = int(input("enter your age"))
        dept = input("enter your department")
        student.insert_many([{"RollNo": rn, "f_name": f_name, "l_name": l_name, "Age": age, "Department": dept}])
    except Exception as e:
        logger.error(f'could not insert document -> {e}')
        print(str(e))


# delete one document
def delete_one(student):
    try:
        data = int(input("enter the id of the document"))
        student.delete_one({"RollNo": data})
    except Exception as e:
        print(str(e))


# delete document using id
def delete_many(student):
    try:
        data = input("enter the name")
        student.delete_many({"f_name": data})
    except Exception as e:
        logger.error(f"could not delete the document -> {e}")
        print(str(e))


# select every document
def select(student):
    try:
        print(list(student.find({}, {"_id": 0})))
    except Exception as e:
        logger.error(f"could retrieve document -> {e}")
        print(str(e))


# update document
def update_one(student):
    try:
        user_id = int(input("enter user roll no."))
        db_field = input("enter the field you want to update")
        field_data = input("enter the data")
        update_doc = {"$set": {db_field: field_data}}
        student.update_many({"RollNo": user_id}, update_doc)
    except Exception as e:
        logger.error(e)
        print(str(e))


# update collection with new field score
def update_field(student):
    try:
        rn = int(input("enter the roll number"))
        cricket = int(input("enter the score of cricket"))
        football = int(input("enter the score of football"))
        volleyball = int(input("enter the score of volleyball"))
        student.update({"RollNo": rn},
                       {"$set":
                            {"score":
                                 {"cricket": cricket, "football": football, "volleyball": volleyball
                                  }
                             }
                        }
                       )
        print("new filed score added to student")
    except Exception as e:
        logger.error(f"could not update the filed due to -> {e}")
        print(str(e))


# update the fields in score
def edit_field(student):
    try:
        rn = int(input("enter the roll number"))
        doc = student.find_one({"RollNo": rn})
        field = input("enter the field you want to update")
        value = int(input("enter the score"))
        doc['sports'][field] = value
        student.save(doc)
    except Exception as e:
        logger.error(f"could not edit the filed due to-> {e}")
        print(str(e))
