# database connection
from scripts.constants.connect import db_connect
from scripts.core.handlers.crud_ops import insert, select, delete_one, update_one, update_field, edit_field
from scripts.logging.logging import logger

try:
    db = db_connect()
    ch = True
    while ch:
        choice = int(input("enter your choice\n1.insert\n2.read\n3.delete"
                           "\n4.update\n5.update with new field score\n6.update score field"))
        if choice == 1:
            insert(db)
            print("data inserted")
        elif choice == 2:
            select(db)
        elif choice == 3:
            delete_one(db)
            print("data deleted")
        elif choice == 4:
            update_one(db)
            print("data updated")
        elif choice == 5:
            update_field(db)
        elif choice == 6:
            edit_field(db)
            print("field value updated")
except Exception as e:
    logger.error(f"an error occurred-> {e}")
    print(e)
