# create database
from scripts.constants.db_connection import db_connect
from scripts.utils.mongo_utils import create_collection

# database connection
db = db_connect()
# create collection
inspection = create_collection(db)


def no_violation():
    try:
        pipeline = [
            {
                '$match': {
                    'result': 'No violation issued'
                }
            }, {
                '$group': {
                    '_id': '$business_name'
                }
            }, {
                "$project": {
                    'business_name': '$_id',
                    '_id': 0
                }
            }
        ]
        result = list(inspection.aggregate(pipeline))
        print(result)
        return result
    except Exception as e:
        print(str(e))


def max_violation():
    try:
        pipeline = [
            {
                '$match': {
                    'result': 'Violation issued'
                }
            }, {
                '$group': {
                    '_id': '$business_name',
                    'count': {
                        '$sum': 1
                    }
                }
            }, {
                '$sort': {
                    'count': -1
                }
            }, {
                '$limit': 1
            }, {
                '$project': {
                    'business_name': '$_id',
                    '_id': 0
                }
            }
        ]
        result = list(inspection.aggregate(pipeline))
        print(result)
        return result
    except Exception as e:
        print(str(e))


def project_fields():
    try:
        pipeline = [
            {
                '$project': {
                    'business_name': 1,
                    'result': 1,
                    'date': 1,
                    '_id': 0
                }
            }
        ]
        result = list(inspection.aggregate(pipeline))
        return result
    except Exception as e:
        print(e)
