from typing import List

from pydantic import BaseModel


class Address(BaseModel):
    city: str
    zip: int
    street: str
    number: int


class CompanyItem(BaseModel):
    id: str
    certificate_number: str
    business_name: str
    date: str
    result: str
    sector: str
    address: Address


class Model(BaseModel):
    Company: List[CompanyItem]
