import json
import pandas as pd
from scripts.config.application_config import file_path
from scripts.database.mongo.mongo_aggregation import inspection, project_fields
from scripts.logging.logging import logger


class MongoHandler:
    @staticmethod
    async def file_upload(file_content):
        try:
            data = json.loads(file_content.decode("utf-8"))
            inspection.insert_many(data)
        except Exception as e:
            logger.error(f"uploading file is failed -> {e}")
            print(e)

    @staticmethod
    def create_excel_file():
        try:
            file_data = project_fields()
            df = pd.DataFrame(file_data)
            df.to_excel(file_path, index=False)
        except Exception as e:
            logger.error(f"could not create an excel file -> {e}")
            print(e)

    @staticmethod
    def open_excel():
        try:
            dataset = pd.read_excel("temp/excel_data.xlsx")
            print(dataset)
        except Exception as e:
            logger.error(f"could not open the excel file -> {e}")
            print(e)
