from fastapi import FastAPI, UploadFile
from scripts.constants.end_points import APIEndpoints
from scripts.core.handlers.mongo_handlers import MongoHandler
from scripts.database.mongo.mongo_aggregation import max_violation, no_violation
from scripts.logging.logging import logger

app = FastAPI(
    title="Mongo Aggregations")


# root API
@app.get(APIEndpoints.root, tags=["root"])
async def root():
    return {"data": "Mongo aggregation task"}


# upload file and store into database
@app.post(APIEndpoints.file_upload, tags=["upload file"])
async def upload_file(file: UploadFile):
    file_content = file.file.read()
    await MongoHandler.file_upload(file_content)
    return {"data": "CSV data uploaded successfully"}


# business name with maximum violation
@app.get(APIEndpoints.max_violation, tags=["tasks"])
async def business_max_violation():
    try:
        re = max_violation()
        return {"data": re}
    except Exception as e:
        logger.error("cant find business name with max violation")
        print(e)


# business name with no violation
@app.get(APIEndpoints.no_violation, tags=["tasks"])
async def business_no_violation():
    try:
        re = no_violation()
        return {"data": re}
    except Exception as e:
        logger.error("cant find business name with no violation")
        print(e)


# create Excel file
@app.get(APIEndpoints.convert_excel, tags=["convert to excel"])
async def convert_excel():
    try:
        MongoHandler.create_excel_file()
        MongoHandler.open_excel()
        return {"data", "Excel file generated based on business name,result and date"}
    except Exception as e:
        logger.error("cant create excel file")
        print(e)
