import requests

from scripts.config import applications_config
from scripts.core.handlers.convert_time_epoch import time_get_epoch
from scripts.core.handlers.create_csv_data import create_csv
from scripts.core.handlers.dictionary_values_tags import key_value_dict
from scripts.core.handlers.query_to_json import get_query
from scripts.core.handlers.send_data import SendData


def main_service_run():
    # Define the base URL for the KairosDB API
    base_url = applications_config.kairos_api
    start_time = time_get_epoch(applications_config.from_date)
    end_time = time_get_epoch(applications_config.end_date)

    mongo_obj = SendData()
    df = mongo_obj.extract_data()
    key_ = mongo_obj.final_dict(df)

    dict_ = []
    for key, value in key_.items():
        dict_.append(key)
    query_data = get_query(dict_, applications_config.name, start_time, end_time)
    # Send the query to the KairosDB API
    response = requests.post(
        base_url,
        data=query_data
    )
    data_ = key_value_dict(response)
    create_csv(key_, data_)
