import pandas as pd

from scripts.core.handlers.epoch_to_date_time import epoch_date_time


def create_csv(key_, data_):
    da = pd.DataFrame(columns=['Timestamp'])
    for key, value in data_.items():
        dp = pd.DataFrame()
        if len(value) != 0:
            dp[['Timestamp', key_[key]]] = [[epoch_date_time(time), data] for time, data in value]
        da = pd.concat([da, dp])
    new_da = da.fillna("NA")
    new_da.to_csv("scripts/temp/ilens.csv", index=False)
