from pymongo import MongoClient
import pandas as pd
from scripts.config.application_config import mongodb_uri, \
    hierarchy_id, username, password

client = MongoClient(mongodb_uri,
                     username=username,
                     password=password)
database = client['ilens_configuration']
collection = database['tag_hierarchy']


class SendData:
    @staticmethod
    def extract_data():
        try:
            tag_hierarchy = collection
            query = {}
            hierarchies = hierarchy_id.split('$')
            for each_hierarchy in hierarchies:
                if "site_" in each_hierarchy:
                    query["site_id"] = each_hierarchy
                elif "dept_" in hierarchies:
                    query["dept_id"] = each_hierarchy
                elif "line_" in each_hierarchy:
                    query["line_id"] = each_hierarchy
                elif "equipment_" in each_hierarchy:
                    query["equipment_id"] = each_hierarchy

            pipeline = [
                {
                    "$match": query
                },
                {
                    '$lookup': {
                        'from': 'tags',
                        'localField': 'parameter_id',
                        'foreignField': 'id',
                        'as': 'tag_details'
                    }
                }, {
                    '$unwind': '$tag_details'
                }, {
                    '$group': {
                        '_id': '$id',
                        'first_document': {
                            '$first': '$$ROOT'
                        }
                    }
                }, {
                    '$replaceRoot': {
                        'newRoot': '$first_document'
                    }
                }, {
                    '$project': {
                        'site_id': '$site_id',
                        'line_id': '$line_id',
                        'equipment_id': '$equipment_id',
                        'site_name': '$site_name',
                        'dept_name': '$dept_name',
                        'line_name': '$line_name',
                        'equipment_name': '$equipment_name',
                        'id': '$id',
                        'tag_name': '$tag_details.tag_name',
                        '_id': 0
                    }
                }
            ]
            tag_names = tag_hierarchy.aggregate(pipeline)
            data = list(tag_names)
            dataset = pd.DataFrame(data)
            return dataset
        except Exception as e:
            print(e)

    @staticmethod
    def final_dict(dataframe):
        try:

            final_data = {}
            for index, row in dataframe.iterrows():
                hierarchy_name = ""
                if row["site_name"] is not None:
                    hierarchy_name = row["site_name"]
                if row["line_name"] != "":
                    hierarchy_name = hierarchy_name + ">" + row["line_name"]
                if row["equipment_name"] != "":
                    hierarchy_name = hierarchy_name + ">" + row["equipment_name"]
                if row["dept_name"] != "":
                    hierarchy_name = hierarchy_name + ">" + row["dept_name"]
                if row["tag_name"] != "":
                    hierarchy_name = hierarchy_name + ":" + row["tag_name"]
                new_dict = {row["id"]: hierarchy_name}
                final_data.update(new_dict)
            print(final_data)
            return final_data
        except Exception as e:
            print(e)


mongo_obj = SendData()
df = mongo_obj.extract_data()
mongo_obj.final_dict(df)
