import json

import pandas as pd

from scripts.config.application_config import file, pivot_path


def json_pivot():
    try:
        data = pd.read_excel(file)
        pivot_json = data.pivot_table(index='Timestamp', values=['kWh','kW'])
        body = {"Pivot": pivot_json.to_dict(orient='records')}
        with open(pivot_path, 'w') as f:
            json.dump(body, f, indent=4)

        # read json file
        # with open(pivot_path, 'r') as f:
        #     data = json.load(f)
        #     print(json.dumps(data, indent=4))
    except Exception as e:
        print(str(e))
