import json

import pandas as pd

from scripts.config.application_config import file, json_path


def json_parsing():
    try:
        data = pd.read_excel(file)
        # print(data)
        # first 10 rows
        first_ten_rows = data.iloc[:10]
        # print(first_ten_rows)
        # last 10 rows
        last_ten_rows = data.iloc[-10:]
        # print(last_ten_rows)

        # concatenation of first and nad 10 rows
        dataframe = pd.concat([first_ten_rows, last_ten_rows], axis=0, ignore_index=True)
        #
        dataframe['Timestamp'] = dataframe["Timestamp"].apply(lambda x: pd.to_datetime(x, unit='ms')
                                                              .strftime('%Y-%m-%d %H:%M:%S'))
        # convert dataframe into JSON file
        header = list(dataframe.columns)
        keys = ['column1', 'column2', 'column2', 'column3', 'column5', 'column6']
        body = {"body": dataframe.to_dict(orient='records')}
        json_header = {'header': dict(zip(keys, header))}
        json_dict = {**json_header, **body}

        with open(json_path, 'w') as data:
            json.dump(json_dict, data, indent=4)
    except Exception as e:
        print(str(e))
