import json

import pandas as pd

from scripts.config.application_config import file, merge_path


def json_merge():
    try:
        data = pd.read_excel(file)
        split_one = data[["current", "kWh"]]
        split_two = data[["current", "kVA"]]
        merge_data = pd.merge(split_one, split_two, on="current")
        body = {"merge file based on current ": merge_data.to_dict(orient='records')}
        with open(merge_path, 'w') as f:
            json.dump(body, f, indent=4)
    except Exception as e:
        print(str(e))
