import json

import pandas as pd

from scripts.config.application_config import file, melt_path


def json_melt():
    try:
        data = pd.read_excel(file)
        melt_json = pd.melt(data, id_vars=["current"], value_vars=["kVA"])
        # melting the data based on current and kVA
        body = {"melting the data based on current and kVA": melt_json.to_dict(orient='records')}
        with open(melt_path, 'w') as f:
            json.dump(body, f, indent=4)

    except Exception as e:
        print(str(e))
