from fastapi import FastAPI, UploadFile
from mongoengine import connect
from scripts.config.application_config import port_connect
from scripts.constants.db_connection import db_connect
from scripts.core.database.model import employee_insert
from scripts.utils.mongo_utils import create_collection
from scripts.core.handlers.fastapi_handler import fastAPIHandler

app = FastAPI()
connect(db="employees", host="localhost", port=int(port_connect))


@app.get("/")
async def root():
    return {"data": "FastAPI CRUD Operations"}


# upload and insert into database
@app.post("/upload", tags=["upload file"])
async def upload_file(file: UploadFile):
    file_content = file.file.read()
    await fastAPIHandler.file_upload(file_content)
    return {"data": "CSV data uploaded successfully"}


# insert data using post method
@app.post("/send_data", tags=['send data'])
def send_data(emp: employee_insert):
    new_employee = employee_insert(id=emp.id,
                                   first_name=emp.first_name,
                                   last_name=emp.last_name,
                                   gender=emp.gender,
                                   phone=emp.phone)
    collection.insert_one(dict(new_employee))
    return {"message": "new data has been inserted"}


# update data
@app.put("/update_data/{doc_id}", tags=["update database"])
def update_data(doc_id: int):
    collection.update_many({"id": doc_id}, {"$set": {"first_name": "ALAN"}})
    return {"data": "data updated"}


# delete data
@app.delete("/delete_data", tags=["delete data"])
def delete_data(doc_id: int):
    collection.delete_many({"id": doc_id})
    return {"data": "data deleted"}


# create database
db = db_connect()
print("database created")
# create collection
collection = create_collection(db)
print("collection created")

