import math


class Shape:
    def __init__(self, area):
        self.area = area

    def get_area(self):
        return self.area.calculate_area()


class Area:
    def calculate_area(self):
        pass


class SquareArea(Area):
    def calculate_area(self, side):
        return side * side


class RectangleArea(Area):
    def calculate_area(self, length, width):
        return length * width


class TriangleArea(Area):
    def calculate_area(self, base, height):
        return 0.5 * base * height


class CircleArea(Area):
    def calculate_area(self, radius):
        return math.pi * radius * radius


# Create area objects
square_area = SquareArea()
rectangle_area = RectangleArea()
triangle_area = TriangleArea()
circle_area = CircleArea()

# Create shape objects and pass in the appropriate area object
square = Shape(square_area)
rectangle = Shape(rectangle_area)
triangle = Shape(triangle_area)
circle = Shape(circle_area)

# Calculate the area of each shape
square_area = square.get_area(5)
rectangle_area = rectangle.get_area(6, 4)
triangle_area = triangle.get_area(3, 2)
circle_area = circle.get_area(7)

# Print the area of each shape
print(square_area)  # 25
print(rectangle_area)  # 24
print(triangle_area)  # 3.0
print(circle_area)  # 153.93804002589985
