from abc import ABC, abstractmethod


# Abstract Product A
class Shape(ABC):
    @abstractmethod
    def draw(self):
        pass


# Concrete Product A1, inherit the class Shape
class Rectangle(Shape):
    def draw(self):
        print("Inside Rectangle::draw() method.")


# Concrete Product A2,inherit the class Shape
class Circle(Shape):
    def draw(self):
        print("Inside Circle::draw() method.")


# Abstract Product B
class Color(ABC):
    @abstractmethod
    def fill(self):
        pass


# Concrete Product B1,inherit the class Color
class Red(Color):
    def fill(self):
        print("Inside Red::fill() method.")


# Concrete Product B2,inherit the class Color
class Blue(Color):
    def fill(self):
        print("Inside Blue::fill() method.")


# Abstract Factory
class AbstractFactory(ABC):
    @abstractmethod
    def create_shape(self):
        pass

    @abstractmethod
    def create_color(self):
        pass


# Concrete Factory 1,inherit the class AbstractFactory
class ShapeColorFactory(AbstractFactory):
    def create_shape(self):
        return Circle()

    def create_color(self):
        return Red()


# Concrete Factory 2,inherit the class AbstractFactory
class ColorShapeFactory(AbstractFactory):
    def create_shape(self):
        return Rectangle()

    def create_color(self):
        return Blue()


# Client code
factory1 = ShapeColorFactory()
shape1 = factory1.create_shape()
color1 = factory1.create_color()
shape1.draw()
color1.fill()
print("--------------------------------")
factory2 = ColorShapeFactory()
shape2 = factory2.create_shape()
color2 = factory2.create_color()
shape2.draw()
color2.fill()
