from fastapi import APIRouter
from scripts.constants.endpoints import EndPoints
from scripts.core.handlers.meals_builder import ComboMealBuilder, MealAssembler

meals = APIRouter()


# CREATIONAL PATTERN BUILDER METHOD
# Register endpoint that uses the builder to build a meal
@meals.get(EndPoints.meals_maker, tags=["meals"])
async def get_meal():
    builder = ComboMealBuilder()
    meal_assembler = MealAssembler(builder)
    meal = meal_assembler.assemble_meal()
    return {"meal": str(meal)}
