from fastapi import APIRouter
from scripts.constants.endpoints import EndPoints
from scripts.core.handlers.shape_handler import CircleFactory, AreaCalculator, RectangleFactory
from scripts.logging.logging import logger

shape = APIRouter()


# CREATIONAL PATTERN -ABSTRACT FACTORY METHOD
# Register endpoints that use the abstract factory
@shape.get(EndPoints.circle_area, tags=["Area of a Circle"])
async def circle_area(radius: float):
    try:
        factory = CircleFactory()
        calculator = AreaCalculator(factory, radius)
        return {"area": calculator.calculate_area()}
    except Exception as e:
        logger.error(e)


@shape.get(EndPoints.rectangle_area, tags=["Area of a Rectangle"])
async def rectangle_area(width: float, height: float):
    try:
        factory = RectangleFactory()
        calculator = AreaCalculator(factory, width, height)
        return {"area": calculator.calculate_area()}
    except Exception as e:
        logger.error(e)
