from abc import ABC, abstractmethod

from scripts.logging.logging import logger


# Product class that we want to build with the builder pattern
class Meal:
    def __init__(self):
        self.drink = None
        self.payasam = None
        self.side = None
        self.dessert = None

    def __repr__(self):
        return f"Meal(drink={self.drink}, payasam={self.payasam}, side={self.side}, dessert={self.dessert})"


# Abstract builder interface
class MealBuilder(ABC):
    @abstractmethod
    def add_drink(self):
        pass

    @abstractmethod
    def add_payasam(self):
        pass

    @abstractmethod
    def add_side(self):
        pass

    @abstractmethod
    def add_dessert(self):
        pass

    @abstractmethod
    def get_meal(self):
        pass


# Concrete builder that builds a combo meal
class ComboMealBuilder(MealBuilder):
    def __init__(self):
        self.meal = Meal()

    def add_drink(self):
        self.meal.drink = "Thumbs UP"

    def add_payasam(self):
        self.meal.payasam = "Pradaman"

    def add_side(self):
        self.meal.side = "Fries"

    def add_dessert(self):
        self.meal.dessert = "Apple pie"

    def get_meal(self):
        return self.meal


# Director class that uses the builder to build the meal
class MealAssembler:
    def __init__(self, builder: MealBuilder):
        try:
            self.builder = builder
        except Exception as e:
            logger.error(e)

    def assemble_meal(self):
        try:
            self.builder.add_drink()
            self.builder.add_payasam()
            self.builder.add_side()
            self.builder.add_dessert()
            return self.builder.get_meal()
        except Exception as e:
            logger.error(e)
