from fastapi import APIRouter
from scripts.constants.endpoints import EndPoints
from scripts.core.handlers.shape_handler import CircleFactory, AreaCalculator, RectangleFactory

shape = APIRouter()


# Register endpoints that use the abstract factory
@shape.get(EndPoints.circle_area, tags=["Area of a Circle"])
async def circle_area(radius: float):
    factory = CircleFactory()
    calculator = AreaCalculator(factory, radius)
    return {"area": calculator.calculate_area()}


@shape.get(EndPoints.rectangle_area, tags=["Area of a Rectangle"])
async def rectangle_area(width: float, height: float):
    factory = RectangleFactory()
    calculator = AreaCalculator(factory, width, height)
    return {"area": calculator.calculate_area()}
