import json
from paho.mqtt import client as mqtt_client
from scripts.config.db_connect import conn1, conn2, conn3

broker = "192.168.0.220"
port = 1883
topic = "site"


def connect_mqtt() -> mqtt_client:
    def on_connect(client, userdata, flags, rc):
        if rc == 0:
            print("Connected to MQTT Broker!")
        else:
            print("Failed to connect, return code %d\n", rc)

    client = mqtt_client.Client()
    client.on_connect = on_connect
    client.connect(broker, port)
    return client


def subscribe(client: mqtt_client):
    def on_message(client, userdata, msg):
        print(f"Received `{msg.payload.decode('utf-8')}` from `{msg.topic}` topic")
        message = json.loads(msg.payload.decode('utf-8'))
        key = message["site_id"]
        value = json.dumps(message["data"])
        if message["data_quality"] == 0:
            conn1.set(key, value)
        if message["data_quality"] == 1:
            conn2.set(key, value)
        if message["data_quality"] == 2:
            conn3.set(key, value)

    client.subscribe(topic)
    client.on_message = on_message


def run():
    client = connect_mqtt()
    subscribe(client)
    client.loop_forever()



