from fastapi import APIRouter
from scripts.constants.endpoints import EndPoints
from scripts.core.handlers.publish_data import MqttHandler
from scripts.database.model.model import DataModel
from scripts.logging.logging_log import logger

publish = APIRouter()


@publish.get("/")
def root():
    return {"data": "API is working"}


@publish.post(EndPoints.publish, tags=["publish the data"])
def data_publish(details: DataModel):
    try:
        MqttHandler.data_publish(dict(details))
        return {"data": "data published"}
    except Exception as e:
        print(e)
        logger.error(e)
