import json
from pydantic import BaseModel


class Site(BaseModel):
    PM10: int
    PM2_5: int
    SO2: int
    NO2: int


class DataModel(BaseModel):
    data: Site
    site_id: str
    data_quality: int


class SitesEncoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, Site):
            return obj.dict()
        return super().default(obj)
