import json
import time
import paho.mqtt.client as mqtt
from scripts.config.application_config import host_name, port_no
from scripts.database.model.model import SitesEncoder
from scripts.logging.logging_log import logger


class MqttHandler:
    @staticmethod
    def data_publish(data):
        try:
            client = mqtt.Client()
            client.connect(host_name, int(port_no), 60)
            topic = "site"
            time.sleep(10)
            client.publish(topic, json.dumps(data, cls=SitesEncoder))
        except Exception as e:
            logger.error(e)
            print(e)
