from pymongo import MongoClient

# Connect to MongoDB
client = MongoClient('mongodb://localhost:27017')
db = client['asset_manager']
collection = db['test']

fetch = {"mac_address": "b8:27:eb:67:bd:3d"}

# New field values
new_tag = {
    "country": "india",
    "state": "kerala",
    "vendor": "seimens",
    "device": "MP201A",
    "customer": "Dalmia"
}

# Add the new field to the "tags" array in all documents
collection.update_many(fetch, {"$push": {"tags": new_tag}}
                       )

# Close the MongoDB connection
client.close()
